<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage config
* @filesource
*//** */

/*
| -------------------------------------------------------------------
| DATABASE CONNECTIVITY SETTINGS
| -------------------------------------------------------------------
| This file will contain the settings needed to access your database.
|
| For complete instructions please consult the 'Database Connection'
| page of the User Guide.
|
| -------------------------------------------------------------------
| EXPLANATION OF VARIABLES
| -------------------------------------------------------------------
|
|	['hostname'] The hostname of your database server.
|	['username'] The username used to connect to the database
|	['password'] The password used to connect to the database
|	['database'] The name of the database you want to connect to
|	['dbdriver'] The database type. ie: mysql.  Currently supported:
				 mysql, mysqli, postgre, odbc, mssql, sqlite, oci8
|	['dbprefix'] You can add an optional prefix, which will be added
|				 to the table name when using the  Active Record class
|	['pconnect'] TRUE/FALSE - Whether to use a persistent connection
|	['db_debug'] TRUE/FALSE - Whether database errors should be displayed.
|	['cache_on'] TRUE/FALSE - Enables/disables query caching
|	['cachedir'] The path to the folder where cache files should be stored
|	['char_set'] The character set used in communicating with the database
|	['dbcollat'] The character collation used in communicating with the database
|				 NOTE: For MySQL and MySQLi databases, this setting is only used
| 				 as a backup if your server is running PHP < 5.2.3 or MySQL < 5.0.7.
| 				 There is an incompatibility in PHP with mysql_real_escape_string() which
| 				 can make your site vulnerable to SQL injection if you are using a
| 				 multi-byte character set and are running versions lower than these.
| 				 Sites using Latin-1 or UTF-8 database character set and collation are unaffected.
|	['swap_pre'] A default table prefix that should be swapped with the dbprefix
|	['autoinit'] Whether or not to automatically initialize the database.
|	['stricton'] TRUE/FALSE - forces 'Strict Mode' connections
|							- good for ensuring strict SQL while developing
|
| The $active_group variable lets you choose which connection group to
| make active.  By default there is only one group (the 'default' group).
|
| The $active_record variables lets you determine whether or not to load
| the active record class
*/

$active_group = 'default';
$active_record = TRUE;

$db['default']['hostname'] = DATABASE_HOSTNAME;
$db['default']['username'] = DATABASE_USERNAME;
$db['default']['password'] = DATABASE_PASSWORD;
$db['default']['database'] = DATABASE_NAME;
$db['default']['dbdriver'] = DATABASE_DRIVER;
$db['default']['dbprefix'] = '';
$db['default']['pconnect'] = FALSE;
$db['default']['db_debug'] = FALSE;
$db['default']['cache_on'] = FALSE;
$db['default']['cachedir'] = '';
$db['default']['char_set'] = 'utf8';
$db['default']['dbcollat'] = 'utf8_general_ci';
$db['default']['swap_pre'] = '';
$db['default']['autoinit'] = TRUE;
$db['default']['stricton'] = FALSE;

$db[MAIL_DATABASE_NAME.'_db']['hostname'] = DATABASE_HOSTNAME;
$db[MAIL_DATABASE_NAME.'_db']['username'] = DATABASE_USERNAME;
$db[MAIL_DATABASE_NAME.'_db']['password'] = DATABASE_PASSWORD;
$db[MAIL_DATABASE_NAME.'_db']['database'] = MAIL_DATABASE_NAME;
$db[MAIL_DATABASE_NAME.'_db']['dbdriver'] = DATABASE_DRIVER;
$db[MAIL_DATABASE_NAME.'_db']['dbprefix'] = '';
$db[MAIL_DATABASE_NAME.'_db']['pconnect'] = FALSE;
$db[MAIL_DATABASE_NAME.'_db']['db_debug'] = FALSE;
$db[MAIL_DATABASE_NAME.'_db']['cache_on'] = FALSE;
$db[MAIL_DATABASE_NAME.'_db']['cachedir'] = '';
$db[MAIL_DATABASE_NAME.'_db']['char_set'] = 'utf8';
$db[MAIL_DATABASE_NAME.'_db']['dbcollat'] = 'utf8_general_ci';
$db[MAIL_DATABASE_NAME.'_db']['swap_pre'] = '';
$db[MAIL_DATABASE_NAME.'_db']['autoinit'] = FALSE;
$db[MAIL_DATABASE_NAME.'_db']['stricton'] = FALSE;

if(is_on_local()){
	$db['default']['db_debug'] = $db[MAIL_DATABASE_NAME.'_db']['db_debug'] = TRUE;
} 



/* End of file database.php */
/* Location: ./application/config/database.php */